<?php
/*
Plugin Name: TSI Visitor Blocker
Description: Advanced visitor, spam and abuse blocker by TSI Digital Solution.
Version: 1.0
Author: TSI Digital Solution
Author URI: https://tsidigitalsolution.com
Plugin URI: https://tsidigitalsolution.com/tsi-visitor-blocker
Text Domain: tsi-visitor-blocker
*/

if (!defined('ABSPATH')) exit;

// Define constant so MU-plugin knows plugin exists
define('TSI_VISITOR_BLOCKER_ACTIVE', true);

// Load core logic
require_once plugin_dir_path(__FILE__) . 'includes/core.php';

/* =====================================================
 * EXPORT / IMPORT BLOCK RULES
 * ===================================================== */

/**
 * Get all block options in one array
 */
function tsi_vb_get_block_rules() {
    return [
        'blocked_ips'       => get_option('tsi_vb_blocked_ips', []),
        'blocked_subnets'   => get_option('tsi_vb_blocked_subnets', []),
        'blocked_emails'    => get_option('tsi_vb_blocked_emails', []),
        'blocked_domains'   => get_option('tsi_vb_blocked_domains', []),
        'blocked_countries' => get_option('tsi_vb_blocked_countries', [])
    ];
}

/**
 * EXPORT handler
 */
add_action('admin_post_tsi_vb_export', function () {

    if (!current_user_can('manage_options')) {
        wp_die('Unauthorized');
    }

    check_admin_referer('tsi_vb_export_nonce');

    $data = tsi_vb_get_block_rules();

    header('Content-Type: application/json');
    header('Content-Disposition: attachment; filename=tsi-visitor-blocker-blocks.json');
    header('Pragma: no-cache');
    header('Expires: 0');

    echo wp_json_encode($data, JSON_PRETTY_PRINT);
    exit;
});

/**
 * IMPORT handler
 */
add_action('admin_post_tsi_vb_import', function () {

    if (!current_user_can('manage_options')) {
        wp_die('Unauthorized');
    }

    check_admin_referer('tsi_vb_import_nonce');

    if (empty($_FILES['tsi_vb_import_file']['tmp_name'])) {
        wp_safe_redirect(admin_url('options-general.php?page=tsi-visitor-blocker&import=fail'));
        exit;
    }

    $json = file_get_contents($_FILES['tsi_vb_import_file']['tmp_name']);
    $data = json_decode($json, true);

    if (!is_array($data)) {
        wp_safe_redirect(admin_url('options-general.php?page=tsi-visitor-blocker&import=invalid'));
        exit;
    }

    $replace = !empty($_POST['tsi_vb_replace']);

    foreach ($data as $key => $values) {

        if (!is_array($values)) {
            continue;
        }

        $option_key = 'tsi_vb_' . $key;
        $existing   = $replace ? [] : get_option($option_key, []);

        $merged = array_unique(array_map('sanitize_text_field', array_merge($existing, $values)));

        update_option($option_key, $merged);
    }

    wp_safe_redirect(admin_url('options-general.php?page=tsi-visitor-blocker&import=success'));
    exit;
});

